////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  OBDirectoryOpenDialog.h
//		Definition of the parent class that allows an Open Dialog through the respective platform's Dialog or Panel.
//
//  Copyright (C) 2011 Acclivity Group LLC. All rights reserved.
//
//  Change History (most recent first):
//
//  06/08/11  G.R.W.  Created file.
//
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma once

#include "CrossPlatform/CrossPlatform.h"

namespace ObsoleteBridge
{
	class EXTERNAL_API OBDirectoryOpenDialog
	{
	public:
		static CPString AskUserToSelectDirectoryWithMessageAndDefaultPath(const CPString& Message, const CPString& DefaultPath);
		static CPString AskUserToSelectDirectoryWithMessagePromptTitleAndDefaultPath(const CPString& MessageText, const CPString& PromptTitle,
																						const CPString& DefaultPath);
		static OBDirectoryOpenDialog* Create(void);
	
		virtual ~OBDirectoryOpenDialog(void);
		
		virtual void SetTitle(const CPString& Title) = 0;
		virtual void SetMessage(const CPString& Message) = 0;
		virtual void SetPromptTitle(const CPString& PromptTitle) = 0;
		virtual void SetDefaultDirectoryPath(const CPString& DefaultDirectoryPath) = 0;
//		virtual void SetDefaultPath(const CPString& DefaultPath) = 0;
		virtual void ShouldAllowMultipleSelection(bool AllowsMultipleSelection) = 0;
		virtual CPString ShowSelectDirectoryDialog(void) = 0;
		virtual CPArray ShowSelectDirectoriesDialog(void) = 0;
		
	protected:
		OBDirectoryOpenDialog(void);
	};
}
